# Encoding: UTF-8.
# Encoding: .

#==============================================================================*.

# TÍTULO DE LA SINTAXIS:							   
# Tabulados	del Registro Estadístico de Rewcursos y Actividades de Salud - RAS   				   
# OPERACIÓN ESTADÍSTICA:													   
# Recursos y Actividades de Salud - RAS				   
# UNIDAD TÉCNICA RESPONSABLE: 												   
# Dirección de Estadísticas Sociodemográficas (DIES)						   
# ENTIDAD EJECUTORA:														   
# Instituto Nacional de Estadística y Censos (INEC)	

#==============================================================================*.

# Fecha última modificación:   Diciembre - 2025.

#==============================================================================*.

# Elaborado por:													   
# Dirección de Estadísticas Sociodemográficas (DIES)						   
# Unidad de Gestión de Estadísticas Sociodemográficas en Base a Registros Administrativos (GESRA)  	   						   
# Aprobado por:													   
# Dirección de Estadísticas Sociodemográficas (DIES)				       
# Unidad de Gestión de Estadísticas Sociodemográficas en Base a Registros Administrativos (GESRA)								       

#==============================================================================*.

# PLAN DE TABULADOS.

# SCRIPt PARA PROCESAR LA BASE DE DATOS DEL RAS 2021 

# **********************************************************************
# *********************SINTAXIS 2 TABULADOS RAS*************************
# **********************************************************************

# Serie No. 1.1.1 Número de establecimientos de salud por sector y tipo Periodo 2000 - 2021.


.Total_nacional_value <- sum(df$total)  

.serie_1 <- df %>% 
  select(total, sector) %>% 
  group_by(sector) %>% 
  summarise(conteo=n(), .groups = 'drop') %>% 
  pivot_wider(
    names_from = sector,
    values_from = conteo,
    values_fill = 0
  )%>%  
  mutate(Total_Nacional = .Total_nacional_value) %>% 
  select(4,1,2,3)

.serie_11 <- df %>%   
  select(total, estcsi) %>%   
  group_by(estcsi) %>%   
  summarise(conteo = n(), .groups = 'drop') %>%   
  pivot_wider(  
    names_from = estcsi,  
    values_from = conteo,  
    values_fill = 0 ) 
.serie_final <- cbind(.serie_1, .serie_11)

Total_nacional_value <- sum(df$total)

serie_1.1.1 <- bind_cols(
  df %>% count(sector, name = "conteo") %>% pivot_wider(names_from = sector, values_from = conteo, values_fill = 0) %>% mutate(Total_Nacional = Total_nacional_value) %>% select(Total_Nacional, everything()),
  df %>% count(estcsi, name = "conteo") %>% pivot_wider(names_from = estcsi, values_from = conteo, values_fill = 0))

# Serie No. 1.1.2 Número de establecimientos de salud por área Período 2000 - 2021.

Total_nacional_value <- sum(df$total)  

serie_1.1.2 <- df %>% 
  select(total, area) %>% 
  group_by(area ) %>% 
  summarise(conteo=n(), .groups = 'drop') %>% 
  pivot_wider(
    names_from = area,
    values_from = conteo,
    values_fill = 0
  )%>%  
  mutate(Total_Nacional = Total_nacional_value) %>% 
  select(3,1,2)

# Serie No. 1.1.3 Número y Tasa de médicos, odontólogos, psicólogos, enfermeras,  obstetrices, auxiliares de enfermería Período 2000 - 2021.

serie_1.1.3<- cuadros_312()
serie_1.1.3 <- head(serie_1.1.3[1,]) %>% 
select(3,4,6,8,10,12,14,5,7,9,11,13,15)

# Serie No. 1.1.4 Número de médicos por sector de investigación Período 2000 - 2021.

serie_1.1.4 <- df %>% 
  select(tmedicos, sector) %>% 
  group_by(sector) %>% 
  summarise(Total_Médicos = sum(tmedicos, na.rm = TRUE), .groups = 'drop') %>% 
  pivot_wider(
    names_from = sector,
    values_from = Total_Médicos,
    values_fill = 0
  ) %>% 
  mutate(Total_Nacional = rowSums(select(., starts_with("sector"), starts_with("privados")), na.rm = TRUE)) %>% 
  select(4,1,2,3)

# Serie No. 1.1.5 Ambientes físicos que dispone el establecimiento de salud Periodo 2000 - 2021

serie_1.1.5 <- df %>% 
  select(k1379, k1380, k1381, k1382) %>%
  summarise(
    k1379 = sum(k1379, na.rm = TRUE),
    k1380 = sum(k1380, na.rm = TRUE),
    k1381 = sum(k1381, na.rm = TRUE),
    k1382 = sum(k1382, na.rm = TRUE
    ) )
names(serie_1.1.5) <- c("Salas de Operaciones","Salas de cuidados intensivos", "Salas de cuidados intermedios", "Salas de parto")

# Serie No. 1.2.1 Número y tasa de Médicos que trabajan en los establecimientos de salud por años, según Regiónes y provincias Período 2006 - 2021.

serie_1.2.1 <- procesar_series(df, "tmedicos", "Total Médicos")

# Serie No. 1.2.2 Número y tasa de odontólogos que trabajan en los establecimientos de salud por años, según Regiónes y provincias Período 2006 - 2021.

serie_1.2.2 <- procesar_series(df, "todont", "Total Odontólogos")

# Serie No. 1.2.3 Número y tasa de psicólogos que trabajan en los establecimientos de salud por años, según Regiónes y provincias Período 2006 - 2021.

serie_1.2.3 <- procesar_series(df, "tpsic", "Total Psicólogos")

# Serie No. 1.2.4 Número y tasa de enfermeras que trabajan en los establecimientos de salud por años, según Regiónes y provincias Período 2006 - 2021.

serie_1.2.4 <- procesar_series(df, "tenf", "Total Enfermeras")

# Serie No. 1.2.5 Número y tasa de obstetrices que trabajan en los establecimientos de salud por años, según Regiónes y provincias  Período 2006 - 2021.

serie_1.2.5 <- procesar_series(df, "tobst", "Total Obstetrices")

# Serie No. 1.2.6 Número y tasa de auxiliares de enfermería que trabajan en los establecimientos de salud por años, según Regiónes y provincias Período 2006 - 2021.

serie_1.2.6 <- procesar_series(df, "tauxenf", "Total Auxiliares de Enfermería")

# Gráfico No. 2.1.1 Número de establecimientos de salud por tipo, según región Año  2021.

gráfico_2.1.1 <- df %>% 
  select(region, estcsi) %>% 
  group_by(region, estcsi) %>% 
  summarise(conteo = n(), .groups = 'drop') %>% 
  pivot_wider(
    names_from = estcsi,
    values_from = conteo,
    values_fill = 0
  ) %>% 
  mutate(Total_Nacional = rowSums(select(., ends_with("internación")), na.rm = TRUE)) %>% 
  select(1, 4, 2, 3)

.totales <- gráfico_2.1.1 %>%
  summarise(across(where(is.numeric), sum), .groups = 'drop') %>%
  mutate(region = "Total Nacional") %>%
  select(region, everything())

gráfico_2.1.1 <- rbind(.totales, gráfico_2.1.1)

# Gráfico No. 2.1.2 Número de establecimientos de salud con internación hospitalaria, según sector de investigación y clase  Año  2021.

gráfico_2.1.2 <- procesar_gráfico(df, "Con Internación", "Con Internación")

# Gráfico No. 2.1.3 Número de establecimientos de salud sin internación hospitalaria, según sector de investigación y clase  Año  2021.

gráfico_2.1.3 <- procesar_gráfico(df, "Sin Internación", "Sin Internación")

# Gráfico No. 2.1.4 Número de establecimientos de salud por tipo, según provincias  Año 2021.

gráfico_2.1.4_1 <- df %>% 
  select(total,prov_ubi) %>% 
  group_by(prov_ubi) %>% 
  summarise(total_establecimientos = n(), .groups = 'drop') %>% 
  arrange(total_establecimientos)

names(gráfico_2.1.4_1) <- c("Provincias", "Total de establecimientos")


gráfico_2.1.4_2 <- df %>% 
  select(prov_ubi, estcsi) %>% 
  group_by(prov_ubi, estcsi) %>% 
  summarise(total_establecimientos = n(), .groups = 'drop') %>% 
  pivot_wider(
    names_from = estcsi,
    values_from = total_establecimientos,
    values_fill = 0
  ) %>%
  select(1,2)

names(gráfico_2.1.4_2) <- c("Provincias", "Con_Internación")

gráfico_2.1.4_2 <- arrange(gráfico_2.1.4_2, Con_Internación)


gráfico_2.1.4_3 <- df %>% 
  select(prov_ubi, estcsi) %>% 
  group_by(prov_ubi, estcsi) %>% 
  summarise(total_establecimientos = n(), .groups = 'drop') %>% 
  pivot_wider(
    names_from = estcsi,
    values_from = total_establecimientos,
    values_fill = 0
  ) %>%
  select(1,3)

names(gráfico_2.1.4_3) <- c("Provincias", "Sin_Internación")

gráfico_2.1.4_3 <- arrange(gráfico_2.1.4_3, Sin_Internación)

# Cuadro 3.1.1 Número de establecimientos de salud por sector y tipo, según Regiónes y provincias Año 2021.

cuadro_3.1.1 <- cuadros_ser3()

# Cuadro 3.1.2 Número y tasas de Médicos, Odontólogos, Enfermeras, Obstetrices, Psicólogos, Auxiliares de Enfermería, que trabajan en establecimientos de salud según regiones y provincias Año 2021.

cuadro_3.1.2 <- cuadros_312()

# Cuadro 3.1.3 Personal que trabaja en establecimientos de salud, según regiones, provincias y área Año 2021.

cols_sumar <- c("tper","tk1","tk2","tk3","tk4","tk5","tk6","tk7","tk8","tk16", 
                "tk9","tk10","tk11","tk12","tk13","tk14","tk15")

nombres_renombrados <- c(
  "region", "prov_ubi", "Total_personal","Médicos_especialistas","Médicos_generales","Médicos_postgradistas",
  "Médicos_residentes","Médicos_rurales","Odontólogos","Obstetrices","Enfermeras",
  "Psicólogos","Otros_profesionales","Licenciados_y_o_tecnólogos",
  "Auxiliares_de_enfermería","Auxiliares_de_servicio_técnico",
  "Personal_de_apoyo_sanitario","Administrativo_y_estadística","De_servicio")

cuadro_3.1.3 <- cuadros_313parm(df, cols_sumar, nombres_renombrados, orden,orden2)

# Cuadro 3.1.4 Personal médico que trabaja en establecimientos de salud por tiempo, según regiones, provincias Año 2021.

columnas_sumar4a = c("tmedicos", "total1", "t8hes", "t6hes", "t4hes", "tevenes")
renombrado_alias4a = c(
  "Total Médicos",
  "Total Médicos especialistas generales",
  "Total Médicos especialistas generales 8h",
  "Total Médicos especialistas generales 6h",
  "Total Médicos especialistas generales 4h",
  "Total Médicos especialistas generales eventual" )

.cuadro_3.1.4a <- cuadros_316gen(
  df = df,
  columnas_sumar = columnas_sumar4a,
  renombrado_alias = renombrado_alias4a)

columnas_sumar4b = c( "total2", "t8hpos", "t6hpos", "t4hpos", "tevenpos")
renombrado_alias4b = c(
  "Total Médicos postgradistas residentesrurales",
  "Total Médicos postgradistas residentesrurales 8h",
  "Total Médicos postgradistas residentesrurales 6h",
  "Total Médicos postgradistas residentesrurales 4h",
  "Total Médicos postgradistas residentesrurales eventual" )

.cuadro_3.1.4b <- cuadros_316gen(
  df = df,
  columnas_sumar = columnas_sumar4b,
  renombrado_alias = renombrado_alias4b)

cuadro_3.1.4 <- bind_cols(.cuadro_3.1.4a, .cuadro_3.1.4b) 
cuadro_3.1.4 <- cuadro_3.1.4[, -8]

# Cuadro 3.1.5 Odontólogos  que trabajan en establecimientos de salud, por tiempo, según regiones y provincias Año 2021.

columnas_sumar5 = c("todont", "tod8", "tod6", "tod4", "todmenos4")
renombrado_alias5 = c(
  "Total Odontólogos",
  "Total Odontólogos 8h",
  "Total Odontólogos 6h",
  "Total Odontólogos 4h",
  "Total Odontólogos eventual" )

cuadro_3.1.5 <- cuadros_316gen(
  df = df,
  columnas_sumar = columnas_sumar5,
  renombrado_alias = renombrado_alias5)

# Cuadro 3.1.6 Otros profesionales que trabajan en establecimientos de salud, por tiempo, según regiones y provincias Año 2021.

  columnas_sumar6 = c("totop", "t8hp", "t6hp", "t4hp", "tevep")
  renombrado_alias6 = c(
    "Total Otros profesionales con titulo universitario",
    "Otros profesionales con titulo universitario 8h",
    "Otros profesionales con titulo universitario 6h",
    "Otros profesionales con titulo universitario 4h",
    "Otros profesionales con titulo universitario eventual" )

  cuadro_3.1.6 <- cuadros_316gen(
  df = df,
  columnas_sumar = columnas_sumar6,
  renombrado_alias = renombrado_alias6)

# Cuadro 3.1.7 Médicos generales y por especialidades, que trabajan en establecimientos de salud, según regiones y provincias Año 2021.

  columnas_sumar7 = c("tmed", "k6", "k11", "k16", "k16a", "k16b", "k16c", "k16d", "k16e", "k16f", "k191d", "k41", "k21", "k26", "k31", "k36", "k46", "k51", "k56", "k61", "k66", "k71", "k76", "k81", "k86", "k91", "k96", "k101", "k106", "k111", "k116",
                     "k121", "k126", "k131", "k136", "k141", "k146", "k151", "tk156", "k171", "k191a", "k191b", "k191c", "k191e", "k191f", "k191g", "k191h", "k191i", "k191j", "k191k", "k191l", "k191m", "k191n", "k191o", "k191p", "k191q", "k191r", "k191s",
                     "k191t", "k191u", "k191w", "k191x", "k191y", "k191z", "k191aa", "k191cc", "k191dd", "k191ee", "k191")
  renombrado_alias7 = c(
    "Total Médicos generales y por especialidad", "Médicos Generales", "Cirujanos Generales", "Cirujanos Plásticos y Reconstructores", "Cirujanos Cardiacos", "Cirujanos Cardiotorácicos", "Cirujanos Cardiovasculares", "Cirujanos de cabeza y cuello",
    "Cirujanos Pediátricos", "Cirujanos Torácicos", "Cirugía Vasculares y Endovasculares", "Ortopédicos y Traumatólogos", "Medicina Interna (Internistas)", "Anestesiólogos", "Cardiólogos", "Neurólogos", "Psiquiatras", "Oftalmólogos", "Otorrinolaringólogos",
    "Hematólogos", "Intensivistas", "Nefrólogos", "Neumólogos", "Gastroenterólogos", "Geriátras y Gerontólogos", "Oncólogos", "Urólogos", "Dermatólogos", "Infectólogos", "Endocrinólogos", "Alergólogos", "Diabetólogos", "Pediatras", "Neonatólogos", "Ginecólogos/Obstetras",
    "De Salud Pública (Salubristas)", "Epidemiólogos", "De Salud Familiar y Comunitaria", "Laboratorio/2", "Radiólogo", "Nutriólogos", "Reumatólogo", "Cardiotorácico", "Neurocirujanos", "Fisiatras", "Médicos Acupunturistas", "Especialistas en Atención Primaria en Salud",
    "Audiólogos / Foniatras", "Biólogos Moleculares", "Genetistas Clínicos", "Genetistas Médicos", "Homeópatas", "Imagenólogos", "Inmunólogos", "Médicos Aeroespaciales", "Médicos Críticos", "Médicos de Emergencia", "Médicos del Deporte", "Médicos Ocupacional", "Médicos Nucleares",
    "Neurofisiólogo Clínico", "Neuropsicólogos", "Parasitólogos", "Proctólogos", "Psiquiatras Infantiles", "Subespecialistas",  "Terapistas Neural", "Especialista en Ultrasonido", "Otros")
  
  cuadro_3.1.7 <- cuadros_316gen(
  df = df,
  columnas_sumar = columnas_sumar7,
  renombrado_alias = renombrado_alias7)

# Cuadro 3.1.8 Odontólogos que trabajan en establecimientos de salud, por especialización, según regiones y provincias Año 2021.

  columnas_sumar8 = c("teod", "k994", "k1004", "k1009", "k1014", "k1019", "k1024", "k1029", "k1034", "k1054", "k1059", "k999")
  renombrado_alias8 = c(
    "Total Especialistas Odontólogos", "Especialización Odontólogos generales", "Especialización Cirujanos maxilofaciales", "Especialización Implantólogos", "Especialización Odontopediátras",
    "Especialización Endodoncistas", "Especialización Periodoncistas", "Especialización Ortodoncistas", "Especialización Rehabilitadores orales", "Especialización Exodoncistas", "Especialización Otros",
    "Odontólogos Rurales")
  
  cuadro_3.1.8 <- cuadros_316gen(
  df = df,
  columnas_sumar = columnas_sumar8,
  renombrado_alias = renombrado_alias8)
  
# Cuadro 3.1.9 Otros profesionales que trabajan en establecimientos de salud, por especialización, según regiones y provincias Año 2021.
  
  columnas_sumar9 = c("tops", "op1", "op11", "op2", "op3", "op4", "op5", "op6", "op7", "op8", "op9", "op10")
  renombrado_alias9 = c(
    "Total profesional", "Especialización Bioquímicos y químicos farmacéuticos", "Especialización Microbiólogos", "Especialización Obstetrices", "Especialización Enfermeras",
    "Especialización Nutricionistas", "Especialización Psicólogos y Psicorehabilitado", "Especialización Educadores para la salud", "Especialización Trabajadoras sociales", "Especialización Ingenieros sanitarios", "Especialización Ingenieros ambientales",
    "Especialización Otros profesionales")
  
   cuadro_3.1.9 <- cuadros_316gen(
   df = df,
   columnas_sumar = columnas_sumar9,
   renombrado_alias = renombrado_alias9)
  
# Cuadro 3.1.10 Licenciados y/o tecnólogos que trabajan en establecimientos de salud, según regiones y provincias Año 2021.
   
   columnas_sumar10 = c("tlict", "k271", "k276", "k281", "k286", "k291", "k296", "k301", "k1049", "k301a", "k306")
   renombrado_alias10 = c(
     "Total personal", "En fisioterapia", "En anestesiología", "En laboratorio clínico", "En hispatología",
     "En radiología", "En saneamiento ambiental", "En alimento", "Mecánico dental", "Paramédicos", "Otros")
   
   cuadro_3.1.10 <- cuadros_316gen(
     df = df,
     columnas_sumar = columnas_sumar10,
     renombrado_alias = renombrado_alias10)
   
# Cuadro 3.1.11 Auxiliares de: enfermería, personal de servicio técnico y personal sanitario de apoyo que trabajan en los establecimientos de salud, según regiones y provincias Año 2021.
   
   columnas_sumar11 = c("ttotal", "taenfer", "k316", "k321", "tst", "k341", "k346", "k336", "k331", "k1044", "k1039", "k351", "k396", "k401", "k406", "k411", "k416", "k416a", "k461")
   renombrado_alias11 = c(
     "Total personal", "Total aux. enfermeria", "Aux Enf Con certificado", "Aux Enf Sin certificado", "Total otros auxiliares", "Servicio técnico De Farmacia", "Servicio técnico De Laboratorio",
     "Servicio técnico De Radiología", "Servicio técnico De Fisioterapia", "Servicio técnico Auxiliares de odontología", "Servicio técnico Asistentes dentales", "Servicio técnico Otros auxiliares", 
     "Total personal sanitario de apoyo", "Personal santario Inspectores sanitarios", "Personal santario Empleados sanitarios", "Personal santario Tecnólogo de atención primaria de salud (TAPS)",
     "Personal santario Otros", "Personal santario Saneamiento Ambiental", "Promotores de salud en la comunidad")
   
   cuadro_3.1.11 <- cuadros_316gen(
     df = df,
     columnas_sumar = columnas_sumar11,
     renombrado_alias = renombrado_alias11)  
   
# Cuadro 3.1.12 Personal de estadística, administrativo y de servicio, que trabaja en establecimientos de salud, según regiones y provincias Año 2021.
  
   columnas_sumar12 = c("ttpesad", "k371", "tadm", "tpserv", "k426", "k431", "k436", "k441", "k446", "k451", "k456")
   renombrado_alias12 = c(
     "Total Personal", "Total personal De Estadística y Admisión", "Total Personal Administrativo", "Total Personal de Servicio", "Personal de Servicio Alimentación y dietética", "Personal de Servicio Lavandería, ropería y costura", "Personal de Servicio Limpieza",
     "Personal de Conserjes, choferes y guardianes", "Personal de Servicio Mantenimiento", "Personal santario Camilleros","Personal de Servicio Otros")
   
   cuadro_3.1.12 <- cuadros_316gen(
     df = df,
     columnas_sumar = columnas_sumar12,
     renombrado_alias = renombrado_alias12)

# Cuadro 3.1.13 Ambientes físicos y equipos de cirugía, obstetricia y cuidados especiales que disponen los establecimientos de salud, según regiones y provincias Año 2021.
   
   columnas_sumar13 = c("k1383", "k1379", "k1380", "k1381", "k1382", "k1403", "k1384", "k1385", "k1386", "k1387", "k1388", "k1389", "k1390", "k1391", "k1392", "k1393", "k1394", "k1395", "k1396", "k1397", "tamfis", "k1402")
   renombrado_alias13 = c(
     "Total Ambientes", "Salas de Operaciones (Quirófanos generales y de emergencia)", "Salas de cuidados intensivos", "Salas de cuidados intermedios", "Salas de parto", "Total Equipos", "Mesas de operaciones", "Equipos de anestesia",
     "Monitores", "Electrobisturí", "Electrocauterio", "Lámpara cielítica", "Coche de paro", "Coche de cardio-reanimación", "Equipo de fibrilación", "Torre de laparoscopía", "Equipo de láser", "Respirador", "Succionador", "Mesas ginecológicas",
     "Cunas, termocunas y/o incubadoras ", "Otros ")
   
   cuadro_3.1.13 <- cuadros_316gen(
     df = df,
     columnas_sumar = columnas_sumar13,
     renombrado_alias = renombrado_alias13)

# Cuadro 3.1.14 Equipo de imagenología, diagnóstico y tratamiento que disponen los establecimientos de salud, según regiones y provincias Año 2021.
   
   columnas_sumar14 = c("k1200", "k1201", "k1201aa", "k1202", "k1203", "k1273", "k1204", "k1205", "k1206", "k1206b", "k1207", "k1265", "k1266", "k1267", "k1268", "k1269", "k1270", "k1271", "k1272", "k1274", "k1275", "k1276", "k1277", "k1343", "k1344", "k1345", "k1346")
   renombrado_alias14 = c(
     "Equipos de Imagenología Rayos X (Fijo)", "Equipos de Imagenología Rayos X (Portátil)", "Equipos de Imagenología Arco en C (fijo o portátil)", "Equipos de Imagenología Tomógrafos", "Equipos de Imagenología Ecógrafos (convencional o portátil)", "Equipos de Imagenología Ecógrafos doppler color", "Equipos de Imagenología Fluoroscopios", "Equipos de Imagenología Mamógrafos",
    "Equipos de Imagenología Resonancia Magnética", "Equipos de Imagenología Desintómetro", "Equipos de Imagenología Otros", "Equipos de Diagnóstico Electroencefalógrafo", "Equipos de Diagnóstico Electrocardiógrafo", "Equipos de Diagnóstico Ecocardiógrafo", "Equipos de Diagnóstico Angiógrafo", "Equipos de Diagnóstico Espirómetro", "Equipos de Diagnóstico Ergonómetro", "Equipos de Diagnóstico Endoscopio", 
    "Equipos de Diagnóstico Colonoscopio","Equipos de Diagnóstico Audiómetro", "Equipos de Diagnóstico Electromiógrafo", "Equipos de Diagnóstico Gammacámara", "Equipos de Diagnóstico Otros", "Equipos de tratamiento Fisioterapia", "Equipos de tratamiento Electroshock", "Equipos de tratamiento Equipo de diálisis","Equipos de Diagnóstico Litotritor")
   
   cuadro_3.1.14 <- cuadros_316gen(
     df = df,
     columnas_sumar = columnas_sumar14,
     renombrado_alias = renombrado_alias14)
   
# Cuadro 3.1.15 Farmacia, botiquín, laboratorio, equipos de esterilización y otros equipos que disponen los establecimientos de salud, según regiones y provincias Año 2021.
   
   columnas_sumar15 = c("kfar1", "kbotq1", "labcl", "labhs", "labot", "k1404", "k1405", "k1406", "k1408", "k1409", "k1410d", "k1410e", "k1410f", "k1410g", "k1410h", "k1410i", "k1410j", "k1410k", "k1410l", "k1410m", "k1410n", "k1410o", "k1410p", "k1410q", "k1410")
   renombrado_alias15 = c(
     "Farmacia", "Botiquín", "Laboratorio / Laboratorio Clínico", "Laboratorio / Laboratorio Hispatológico", "Laboratorio Otros", "Equipo de esterilización / Esterilizador en seco", "Equipo de esterilización / Auto claves", "Equipo de esterilización / Otros", "Vehículos / Ambulancias",
     "Vehículos / Vehículos de transporte", "Otros equipos o instrumentos Camas de recuperación", "Otros equipos o instrumentos Camas de emergencia", "Otros equipos o instrumentos Sillones (Quimioterapias, diálisis y otros)", "Otros equipos o instrumentos Camillas", 
     "Otros equipos o instrumentos Sillas para nebulizaciones", "Otros equipos o instrumentos Balanzas de recien nacidos", "Otros equipos o instrumentos Balanzas de pedestal", "Otros equipos o instrumentos Tensiometros de pedestal", "Otros equipos o instrumentos Tensiometros de pared", 
     "Otros equipos o instrumentos Fonendoscopio", "Otros equipos o instrumentos Refrigeradoras (uso de medicamento)","Otros equipos o instrumentos Vaporizador", "Otros equipos o instrumentos Tensiometro digital","Otros equipos o instrumentos Shailon", "Otros equipos o instrumentos Otros")
   
   cuadro_3.1.15 <- cuadros_316gen(
     df = df,
     columnas_sumar = columnas_sumar15,
     renombrado_alias = renombrado_alias15) 
           
# Cuadro 3.1.16 Equipos odontolólogicos que disponen los servicios de estomatología de los establecimientos de salud, según regiones y provincias Año 2021.

   columnas_sumar16 = c("tequod", "k978", "k979", "k980", "k981", "k982", "k983", "k984", "k985", "k986", "k987", "k988", "k989", "k990", "k991", "k992a", "k992b", "k992c", "k992d", "k992")
   renombrado_alias16 = c(
     "Total Equipos Odontologicos", "Computador completo pc/computador portátil", "Equipo odontológico", "Compresor de odontología", "Esterilizador y/o autoclave", "Ultrasonido (cavitrón)", "Taburete giratorio dental", "Equipo instrumental para operatoria dental", "Negatoscopio",
     "Equipo instrumental de cirugía dental", "Equipo instrumental de diagnóstico dental", "Equipo instrumental de profilaxís dental", "Set de desechos", "Fregadero mas escurridor", "Equipo de RX de odontología", "Micromotor", "Turbina", "Lampara halógena", "Sillón dental", 
     "Otros")
   
   cuadro_3.1.16 <- cuadros_316gen(
     df = df,
     columnas_sumar = columnas_sumar16,
     renombrado_alias = renombrado_alias16)   

# Cuadro 3.1.17 Consultas de morbilidad, prevención, esmatologìa, emergencia, Número de Urgencias, Número de Atenciones (urgencias), Número de Ingresos /emergencias y  Número de Intervenciones Quirúrgicas en el servicio de hospitalización de los establecimientos de salud, según regiones y provincias Año 2021.
   
   columnas_sumar17 = c("tcmps", "mprim", "msubs", "tconpr", "tpc", "tspc", "tcest", "k1105", "k1106", "k1107", "k974", "k975", "k976", "k977c")
   renombrado_alias17 = c(
     "Consultas de morbilidad Total", "Consultas de morbilidad Primeras", "Consultas de morbilidad Subsecuentes", "Consultas de prevención Total", "Consultas de prevención Primeras", "Consultas de prevención Subseceuntes", "Consultas de estomatología Total", "Consultas de estomatología Morbilidad", "Consultas de estomatología Prevención primeras",
     "Consultas de estomatología Prevención subsecuentes", "Número de Urgencias domicilio", "Número de Atenciones (urgencias)", "Número de Ingresos emergencias", "Número de Intervenciones Quirúrgicas en el servicio de hospitalización")
   
   cuadro_3.1.17 <- cuadros_316gen(
     df = df,
     columnas_sumar = columnas_sumar17,
     renombrado_alias = renombrado_alias17)  
   
# Cuadro No. 3.1.18 Consultas de morbilidad (primeras y subsecuentes) realizadas en los establecimientos de salud por sector y entidad, según regiones y provincias Año 2021.
   
    cuadro_3.1.18 <- cuadros_sec_ent(
    data = df,
    vars_to_sum = c("tcmps")
  )

# Cuadro 3.1.19 Consultas de morbilidad (primarias y subsecuentes), de los establecimientos de salud, realizadas en los establecimientos de salud  por grupos de edad, según regiones y provincias Año 2021.
  
  columnas_sumar19 = c("tconed", "e1", "e2", "e3", "e4", "e5", "e6", "e7", "e8", "e9", "e10", "e11")
  renombrado_alias19 = c(
    "Consultas de morbilidad Total", "Consultas de morbilidad Menos de 1 mes", "Consultas de morbilidad 1 - 11 meses", "Consultas de morbilidad 1 - 4 años", "Consultas de morbilidad  5  -  9 años", "Consultas de morbilidad 10 - 14 años", "Consultas de morbilidad 15 - 19 años", "Consultas de morbilidad 20 - 35 años", "Consultas de morbilidad 36 - 49 años",
    "Consultas de morbilidad 50 - 64 años", "Consultas de morbilidad 65 y más años", "Consultas de morbilidad Edad no especificada")
  
  cuadro_3.1.19 <- cuadros_316gen(
    df = df,
    columnas_sumar = columnas_sumar19,
    renombrado_alias = renombrado_alias19) 
   
# Cuadro No. 3.1.20 Consultas de morbilidad  realizadas por médico, obstetriz y psicólogo en los establecimientos de salud, según regiones, provincias y área Año 2021.
  
  cols_sumar20 <- c("tcmm","tcmos","tcmpsi")
  nombres_renombrados20 <- c(
    "region", "prov_ubi", "Médico", "Obstetriz", "Psicólogo")

  cuadro_3.1.20 <- cuadros_313parm(df, cols_sumar20, nombres_renombrados20, orden,orden2)
  
# Cuadro No. 3.1.21 Consultas de prevención de los establecimientos de salud, según regiones y provincias Año 2021.
  
  columnas_sumar21 = c("tcpps", "pprim", "psubs")
  renombrado_alias21 = c(
    "Consultas de prevención Total", "Consultas de prevención Primeras ", "Consultas de prevención Subsecuentes ")
  
  cuadro_3.1.21 <- cuadros_316gen(
    df = df,
    columnas_sumar = columnas_sumar21,
    renombrado_alias = renombrado_alias21) 
  
# Cuadro 3.1.22 Primeras consultas de prevención y gineco-obstétricas, realizadas en los establecimientos de salud, por sector y entidad, según grupos edad Año 2021.
  
 # df_sum: columnas -> sector, entidad, tpc, tn, tprv1, ..., tedad
 
 indicatorsa <- c("tpc","tn","tprv1","tprv2","tprv3","ta","tprv4","tprv5","tad","tprv6",
                 "tprv7","tprv8","tprv9","totalpar1","tprv10","tpartom","tprv11",
                 "totalpar2","tprv12","tpartoh","tprv13","tedad")
 nombres_filasa <- c("Consultas Primarias","Niños","Menores de 1 año","1 - 4 años","5 - 9 años","Adolescentes"," 10 - 14 años ",
                    "15 - 19 años","Adultos","20 - 35 años", "36 - 49 años","50 - 64 años","65 años y más","Mujeres 10 - 19 años",
                    "Prenatal 10 - 19 años","Atención partos 10 - 19 años","Post-parto 10 - 19 años","Mujeres 20 - 50 años",
                    "Prenatal 20 - 50 años","Atención partos 20 - 50 años","Post-parto 20 - 50 años","Edad no especificada")
 
  cuadro_3.1.22a<- transform_indicadores_wide(df, indicatorsa)%>% 
    select(1,23,20,2,3,4,5,6,7,8,9,10,11,12,13,21,14,22,15,16,17,18,19) 
  
  if (nrow(cuadro_3.1.22a) != length(nombres_filasa)) {
    stop("El vector de nuevos nombres debe tener la misma cantidad de filas que df.")
  }
  
  cuadro_3.1.22a$indicador <- nombres_filasa
  names(cuadro_3.1.22a)[1] <- "Grupos de Edad"
  

  indicatorsb <- c("tpf","tprv14","tprv32","tprv33","tprv34","tprv16","tprv17","tprv18","tprv19","tprv20",
                  "tprv35","tprv36","tprv37","tprv38","tcan","tprv23","tprv24","tprv25","tprv26","tprv27",
                  "tprv28","tprv29","tprv30","ttiro","ttotr","tprv31")
  nombres_filasb <- c("Planificación familiar","Dispositivo intrauterino diu","Anticonceptivos Orales Combinados","Anticonceptivos Orales sólo progesterona",
                      "Anticonceptivo Oral de emergencia"," Inyectable ","Preservativos","Implantes", "Vasectomía","Salpingectomía","Anillo Vaginal","Parche Trandérmico",
                     "Otros","Total sin metodos desglosados","Detección oportuna del cáncer","Cérvicouterino",
                     "Mamario","Próstata","Pulmonar","Gástrico","Hepático","Colorrectal","Piel","Tiroide","Otros","Parto")
  
  cuadro_3.1.22b <- transform_indicadores_wide(df, indicatorsb) %>% 
    select(1,23,20,2,3,4,5,6,7,8,9,10,11,12,13,21,14,22,15,16,17,18,19) 
  
  if (nrow(cuadro_3.1.22a) != length(nombres_filasa)) {
    stop("El vector de nuevos nombres debe tener la misma cantidad de filas que df.")
  }

  cuadro_3.1.22b$indicador <- nombres_filasb
  names(cuadro_3.1.22b)[1] <- "Dispositivos de planificación familiar"
  

# Cuadro No. 3.1.23 Consultas subsecuentes de prevención y gineco-obstétricas realizadas en los establecimientos de salud por sector y entidad, según grupos edad Año 2021.  
 
  indicators23 <- c("tspc","tsn","tsk1","tsk2","tsk3","tsad","tsk4","tsk5","tsadu","tsk6",
                   "tsk7","tsk8","tsk9","tsmu","tsk10","tsk11","tedads","tspf","tsk12","tsk13",
                   "tsk19","tsk20","tsk14","tsk15","tsk16","tsk17","tsk18","tsk21","tsk22","tsk23","tsk24")
  nombres_filas23 <- c("Consultas Subsecuentes","Niños","Menores de 1 año","1 - 4 años","5 - 9 años"," Adolescentes ","10 - 14 años","15 - 19 años", "Adultos","20 - 35 años","36 - 49 años","50 - 64 años",
                      "65 años y más","Mujeres","Prenatal 10 - 19 años","Prenatal 20 - 49 años","Planificación familiar","Dispositivo intrauterino diu","Anticonceptivos Orales Combinados",
                      "Anticonceptivos Orales sólo progesterona","Anticonceptivo Oral de emergencia","Colorrectal","Inyectable","Preservativos","Implantes","Vasectomía","Salpingectomía","Anillo Vaginal",
                      "Parche Trandérmico","Otros","Total sin metodos desglosados")
  
  cuadro_3.1.23 <- transform_indicadores_wide(df, indicators23)  %>% 
    select(1,23,20,2,3,4,5,6,7,8,9,10,11,12,13,21,14,22,15,16,17,18,19) 
  
  if (nrow(cuadro_3.1.23) != length(nombres_filas23)) {
    stop("El vector de nuevos nombres debe tener la misma cantidad de filas que df.")
  }
  
  cuadro_3.1.23$indicador <- nombres_filas23
  names(cuadro_3.1.23)[1] <- "Grupos programáticos"
  
# Cuadro 3.1.24 Visitas domiciliarias , de médico, obstetriz y enfermera, realizadas por los establecimientos de salud, por sector y clase de establecimiento, según regiones y provincias Año 2021.

 .resultado1 <- cuadros_sector(
    data = df,
    vars_to_sum = c("k972")
  )
  .resultado1 <- .resultado1%>%
  select(2,6,3,4,5,)
    
  .resultado2 <- cuadros_sec_clase(
    data = df,
    vars_to_sum = c("k972")
  )

  .resultado2 <- .resultado2%>% 
    select(40,3,4,32,33,5,6,26,7,8,9,10,11,12,29,13,14,36,41,15,16,17,37,34,39,35,30,31,18,19,20,18,27,28,42,21,35,22,23,32,25,30,37,24,25,38)
  
  cuadro_3.1.24 <- cbind(.resultado1, .resultado2)
  names(cuadro_3.1.24)[1] <- "Regiones / Provincia"
  
# Cuadro No. 3.1.25 Consultas de morbilidad de estomatología realizadas por los establecimientos de salud por grupos de edad, según regiones y provincias Año 2021.
  
  columnas_sumar25 = c("tnin", "k1069", "k1072", "k1075", "tadole", "k1078", "k1084", "k1081", "tadult", "k1087", "k1090", "k1093", "k1096", "k1099", "k1102a", "k1102")
  renombrado_alias25 = c(
    "Total Niños", "Niños Menores de 1 año", "Niños 1 - 4 años", "Niños 5 - 9 años programados", "Total Adolescentes", "Adolescentes 10 - 14 años programados", "Adolescentes 15 - 19 años",  
    "5 - 14 años no programados", "Total Adultos", "Adultos 20 -35 años", "Adultos 36 - 49 años", "Adultos 50 - 64 años", "Adultos 65 y más años", " Embarazadas", "Edad no especificada", " Total sin grupos de edad")
  
  cuadro_3.1.25 <- cuadros_316gen(
    df = df,
    columnas_sumar = columnas_sumar25,
    renombrado_alias = renombrado_alias25) 

# Cuadro 3.1.26 Primeras consultas de prevención de estomatología, realizadas por los establecimientos de salud, por grupos de edad, según regiones, provincia Año 2021.
  
  columnas_sumar26 = c("k1106", "tpnin", "k1070", "k1073", "k1076", "tpadole", "k1079", "k1085", "k1082", "tpadult", "k1088", "k1091", "k1094", "k1097", "k1100", "k1103a", "k1103")
  renombrado_alias26 = c(
    "Total primeras consultas prevención odontología", "Total Niños", "Niños Menores de 1 año", "Niños 1 - 4 años", "Niños 5 - 9 años programados", "Total Adolescentes", "Adolescentes 10 - 14 años programados", "Adolescentes 15 - 19 años",  
    "5 - 14 años no programados", "Total Adultos", "Adultos 20 -35 años", "Adultos 36 - 49 años", "Adultos 50 - 64 años", "Adultos 65 y más años", " Embarazadas", "Edad no especificada", " Total sin grupos de edad")
  
  cuadro_3.1.26 <- cuadros_316gen(
    df = df,
    columnas_sumar = columnas_sumar26,
    renombrado_alias = renombrado_alias26)  
  
# Cuadro 3.1.27 Consultas subsecuentes de prevención de estomatología, realizadas por los establecimientos de salud, por grupos de edad, según regiones, provincias Año 2021.
  
  columnas_sumar27 = c("k1107", "tsnin", "k1071", "k1074", "k1077", "tsadole", "k1080", "k1086", "k1083", "tsadult", "k1089", "k1092", "k1095", "k1098", "k1101", "k1104a", "k1104")
  renombrado_alias27 = c(
    "Total consultas subsecuentes de prevención odontología", "Total Niños", "Niños Menores de 1 año", "Niños 1 - 4 años", "Niños 5 - 9 años programados", "Total Adolescentes", "Adolescentes 10 - 14 años programados", "Adolescentes 15 - 19 años",  
    "5 - 14 años no programados", "Total Adultos", "Adultos 20 -35 años", "Adultos 36 - 49 años", "Adultos 50 - 64 años", "Adultos 65 y más años", " Embarazadas", "Edad no especificada", " Total sin grupos de edad")
  
  cuadro_3.1.27 <- cuadros_316gen(
    df = df,
    columnas_sumar = columnas_sumar27,
    renombrado_alias = renombrado_alias27)    
  
# Cuadro 3.1.28 Actividades de estomatología, radiografías dentales y certificados odontológicos realizadas por los establecimientos de salud, según regiones y provincias.Año 2021.
  
  columnas_sumar28 = c("k1108", "k1109", "k1110", "k1111", "k1112", "k1113", "k1114", "k1114a", "k1116", "k1117", "k1118", "k1118a", "k1120", "k1121")
  renombrado_alias28 = c(
    "Actividades de morbilidad Obturación", "Actividades de morbilidad Restauración", "Actividades de morbilidad Endodoncias", "Actividades de morbilidad Exodoncias", "Actividades de morbilidad Periodoncias", "Actividades de morbilidad Cirugía Menor", "Actividades de morbilidad Ortodoncia / Ortopedia",  
    "Actividades de morbilidad Sin actividades desagregadas", "Actividades de prevención Profilaxis", "Actividades de prevención Aplicación de Fluor", "Actividades de prevención Sellantes", "Actividades de prevención Sin actividades desagregadas.", "Número de Radiografías Dentales", "Número de Certificados Odontológicos")
  
  cuadro_3.1.28 <- cuadros_316gen(
    df = df,
    columnas_sumar = columnas_sumar28,
    renombrado_alias = renombrado_alias28)    
 
# Cuadro 3.1.29 Actividades de estomatología, radiografías dentales y certificados odontológicos realizadas por los establecimientos de salud, según sector y entidad. Año 2021.
  
  columnas_k_vector <- c("k1108", "k1109", "k1110", "k1111", "k1112", "k1113", "k1114", 
                         "k1114a", "k1116", "k1117", "k1118", "k1118a", "k1120", "k1121")
  nuevos_nombres = c("Sector Entidad",
    "Actividades de morbilidad Obturación", "Actividades de morbilidad Restauración", "Actividades de morbilidad Endodoncias", "Actividades de morbilidad Exodoncias", "Actividades de morbilidad Periodoncias", "Actividades de morbilidad Cirugía Menor", "Actividades de morbilidad Ortodoncia / Ortopedia",  
    "Actividades de morbilidad Sin actividades desagregadas", "Actividades de prevención Profilaxis", "Actividades de prevención Aplicación de Fluor", "Actividades de prevención Sellantes", "Actividades de prevención Sin actividades desagregadas.", "Número de Radiografías Dentales", "Número de Certificados Odontológicos")
  
  cuadro_3.1.29 <- cuadro3129(
    df = df,
    columnas_k = columnas_k_vector) 
  
  cuadro_3.1.29 <- cuadro_3.1.29[, -1]
  colnames(cuadro_3.1.29) <- nuevos_nombres
  
# Cuadro 3.1.30 Consultas de morbilidad y prevención de estomatología realizadas por los establecimientos de Salud por entidad, según regiones y provincias. Año 2021.
  
  columnas_k_vec <- c("k1105")
  nuevos_nombres = c("Sector Entidad",
                     "Actividades de morbilidad Obturación", "Actividades de morbilidad Restauración", "Actividades de morbilidad Endodoncias", "Actividades de morbilidad Exodoncias", "Actividades de morbilidad Periodoncias", "Actividades de morbilidad Cirugía Menor", "Actividades de morbilidad Ortodoncia / Ortopedia",  
                     "Actividades de morbilidad Sin actividades desagregadas", "Actividades de prevención Profilaxis", "Actividades de prevención Aplicación de Fluor", "Actividades de prevención Sellantes", "Actividades de prevención Sin actividades desagregadas.", "Número de Radiografías Dentales", "Número de Certificados Odontológicos")
  
  
  cuadro_3.1.30 <- cuadros_clase(
    data = df,
    vars_to_sum = columnas_k_vec
  )
  
# Cuadro 3.1.31 Consultas y actividades (Prevención) de estomatología realizadas por los establecimientos de Salud, según regiones y provincias.Año 2021.
  
  columnas_sumar31 = c("totalpsub", "k1106", "k1107", "k1119", "k1116", "k1117", "k1118", "k1118a")
  renombrado_alias31 = c(
    "Total Consultas de Prevención", "Consultas de Prevención Primeras", "Consultas de Prevención Subsecuentes", "Total Actividades de prevención", "Actividades de prevención Profilaxis", "Actividades de prevención Aplicación de Fluor", "Actividades de prevención Sellantes", "Actividades de prevención Sin actividades desagregadas")
  
  cuadro_3.1.31 <- cuadros_316gen(
    df = df,
    columnas_sumar = columnas_sumar31,
    renombrado_alias = renombrado_alias31)  
  
# Cuadro 3.1.32 Determinaciones de laboratorio, exámenes anatomía patológica y recetas despachadas en las farmacias de los establecimientos de salud, según regiones y provincias.Año 2021.
  
  columnas_sumar32 = c("k1122", "k1126", "k1130", "k1134", "k1138", "k1142", "k1146", "k1150", "k1154", "k1158", "k1162", "k1166", "k1170", "k1174a", "k1174b", "k1174", "k1182", "k1185", "k1188", "k1190", "k1199")
  renombrado_alias32 = c(
    "Exámenes de Laboratorio / Flebotomía", "Exámenes de Laboratorio / Hematologia", "Exámenes de Laboratorio / Quimica Sanguinea", "Exámenes de Laboratorio / Inmunología", "Exámenes de Laboratorio / Uroanálisis", "Exámenes de Laboratorio / Coproanálisis", "Exámenes de Laboratorio / Microbiología", "Exámenes de Laboratorio / Serologia", "Exámenes de Laboratorio / Hormonas", "Exámenes de Laboratorio / Tuberculosis", 
    "Exámenes de Laboratorio / Biología Molecular (opcional)", "Exámenes de Laboratorio / Toxicología (opcional)", "Exámenes de Laboratorio / Genética (opcional)", "Exámenes de Laboratorio / Pruebas de VIH (Positivas)", "Exámenes de Laboratorio / Pruebas de VIH (Negativas)", "Exámenes de Laboratorio / Otros", "Anatomía patológica / Exámenes Histopatológicos", "Anatomía patológica / Citológicos", "Anatomía patológica / Autopsias", 
    "Anatomía patológica / Otros", "Recetas despachadas en farmacia")
    
  cuadro_3.1.32 <- cuadros_316gen(
    df = df,
    columnas_sumar = columnas_sumar32,
    renombrado_alias = renombrado_alias32)  
  
# Cuadro 3.1.33 Exámenes de imagenología, realizados en los establecimientos de salud, según regiones y provincias. Año 2021.
  
  columnas_sumar33 = c("tklg1", "tklg2", "tklg3", "tklg4", "tklg5", "tklg6", "tklg7")
  renombrado_alias33 = c(
    "Exámenes de Imagenología / Radiografías", "Exámenes de Imagenología / Ecografías", "Exámenes de Imagenología / Tomografías", "Exámenes de Imagenología / Mamografías", "Exámenes de Imagenología / Dosimetría ósea", "Exámenes de Imagenología / Resonancia magnética nuclear intervencionista", "Exámenes de Imagenología / Otros")
  
  cuadro_3.1.33 <- cuadros_316gen(
    df = df,
    columnas_sumar = columnas_sumar33,
    renombrado_alias = renombrado_alias33)  
  
# Cuadro 3.1.34 Pruebas de diagnóstico, realizadas en los establecimientos de salud, según regiones y provincias. Año 2021.
  
  columnas_sumar34 = c("k1279", "k1283", "k1287", "k1291", "k1295", "k1299", "k1303", "k1307", "k1315", "k1319", "k1335")
  renombrado_alias34 = c(
    "Pruebas de Diagnóstico / Electroencefalogramas", "Pruebas de Diagnóstico / Electrocardiogramas", "Pruebas de Diagnóstico / Ecocardiogramas", "Pruebas de Diagnóstico / Angiografías", "Pruebas de Diagnóstico / Espirometrías", "Pruebas de Diagnóstico / Ergonometrías", "Pruebas de Diagnóstico / Endoscopías", "Pruebas de Diagnóstico / Colonoscopías", "Pruebas de Diagnóstico / Audiometrías", "Pruebas de Diagnóstico / Electromiogramas", "Pruebas de Diagnóstico / Otros")
  
  cuadro_3.1.34 <- cuadros_316gen(
    df = df,
    columnas_sumar = columnas_sumar34,
    renombrado_alias = renombrado_alias34)
  
# Cuadro 3.1.35 Tratamientos de fisioterapia, diálisis, radioisótopos y otros tratamientos, realizados en los establecimientos de salud, según regiones y provincias. Año 2021.
  
  columnas_sumar35 = c("k1369", "k1348", "k1351", "k1354", "k1357", "k1360", "k1363", "k1363a", "k1366", "k1376", "k1376a", "k1376b", "k1376bb", "k1376c", "k1376d", "k1376e", "k1323", "k1326", "k1329", "k1332", "k1372", "k1373", "k1374")
  renombrado_alias35 = c(
    "Total Fisioterapia", "Tratamiento de Fisioterapia / Electroterapia", "Tratamiento de Fisioterapia / Hidroterapia", "Tratamiento de Fisioterapia / Ejercicios Terapeúticos", "Tratamiento de Fisioterapia / Parafina", "Tratamiento de Fisioterapia / Compresas químicas", "Tratamiento de Fisioterapia / Termoterapia", "Tratamiento de Fisioterapia / Litotricia", "Tratamiento de Fisioterapia / Otros", "Total tratamientos de diálisis, quimioterapia, radioterapia y hemodiálisis", 
    "Tratamientos de diálisis, quimioterapia, radioterapia y hemodiálisis / Tratamientos de diálisis", "Tratamientos de diálisis, quimioterapia, radioterapia y hemodiálisis / Tratamientos de quimioterapia", "Tratamientos de diálisis, quimioterapia, radioterapia y hemodiálisis / Tratamientos de quimioterapias tópicos", "Tratamientos de diálisis, quimioterapia, radioterapia y hemodiálisis / Tratamientos de radioterapia", "Tratamientos de diálisis, quimioterapia, radioterapia y hemodiálisis / Tratamientos de hemodiálisis", 
    "Tratamientos de diálisis, quimioterapia, radioterapia y hemodiálisis / Otros", "Pruebas de diagnóstico con radioisótopos / Gammagrafía Tiroidea", "Pruebas de diagnóstico con radioisótopos / Gammagrafía Ósea", "Pruebas de diagnóstico con radioisótopos / Gammagrafía Renal", "Pruebas de diagnóstico con radioisótopos / Gammagrafía de Otros Órganos", "Otros Tratamientos / Terapia de lenguaje", "Otros Tratamientos / Terapia respiratoria", "Otros Tratamientos / Terapia ocupacional")
  
  cuadro_3.1.35 <- cuadros_316gen(
    df = df,
    columnas_sumar = columnas_sumar35,
    renombrado_alias = renombrado_alias35)
  
  # Cuadro 3.1.36 Actividades de trabajo social, realizadas por los establecimientos de salud, según regiones y provincias.Año 2021.
  
  columnas_sumar36 = c("k1418", "k1419", "k1420", "k1421", "k1422", "k1423")
  renombrado_alias36 = c(
    "Entrevistas", "Visitas Domiciliarias / Visitas domiciliarias efectivas", "Visitas Domiciliarias / Visitas domiciliarias inefectivas", "Gestiones Intra institucionales", "Gestiones Extra institucionales", "Servicio Social a la comunidad")
  
  cuadro_3.1.36 <- cuadros_316gen(
    df = df,
    columnas_sumar = columnas_sumar36,
    renombrado_alias = renombrado_alias36)
  
# Cuadro 3.1.37 Actividades de vigilancia sanitaria, realizadas por los establecimientos de salud, según regiones y provincias.Año 2021.
  
  columnas_sumar37 = c("k1412", "k1413", "k1414", "k1415", "k1416")
  renombrado_alias37 = c(
    "Viviendas", "Establecimientos educacionales", "  Establecimientos públicos en general", "  Establecimientos de expendio de alimentos", "  Otras")
  
  cuadro_3.1.37 <- cuadros_316gen(
    df = df,
    columnas_sumar = columnas_sumar37,
    renombrado_alias = renombrado_alias37)  
  
# Cuadro 3.1.38 Total de Médicos por sector y clase, según regiones, provincias y cantones. Año 2021.
  
  .cuerpo_tabla <- df %>% 
    select(region, prov_ubi, cant_ubi, sector, clase, tmedicos) %>% 
    group_by(region, prov_ubi, cant_ubi, sector, clase) %>% 
    summarise(Total_Médicos = sum(tmedicos, na.rm = TRUE), .groups = 'drop') %>% 
    pivot_wider(
      names_from = c(sector, clase), 
      values_from = Total_Médicos,
      values_fill = 0,
      names_sep = "_" 
    ) %>% 
    # Suma horizontal
    mutate(Total_Nacional = rowSums(select(., where(is.numeric)), na.rm = TRUE)) %>% 
    # Reordenar: Ubicaciones primero, luego el Total Nacional y el resto
    select(region, prov_ubi, cant_ubi, Total_Nacional, everything())
  
  # 2. Crear la fila de Total Nacional (Suma vertical)
  .fila_total <- .cuerpo_tabla %>%
    summarise(across(where(is.numeric), sum)) %>%
    mutate(
      region = "TOTAL", 
      prov_ubi = "NACIONAL", 
      cant_ubi = "TOTAL NACIONAL"
    ) %>%
    # ESTO ES LO QUE FALTABA: Forzar el orden exacto de columnas del cuerpo
    select(region, prov_ubi, cant_ubi, Total_Nacional, everything())
  
  # 3. Unir (La fila de total queda arriba y todos los cantones abajo)
  cuadro_3.1.38 <- bind_rows(.fila_total, .cuerpo_tabla)
  
# Cuadro 3.1.39 Número de Médicos, Odontólogos, Enfermeras, Obstetrices, Psicólogos, Auxiliares de Enfermería, que trabajan en establecimientos de salud según regiones, provincias y cantones Año 2021.
 
  columnas_sumar39 = c("tmedicos", "todont", "tpsic", "tenf", "tobst", "tauxenf")
  renombrado_alias39 = c(
    "Médicos", "Odontólogos", "Psicólogos", "Enfermeras", "Obstetras", "Auxiliares de Enfermería")
  
  cuadro_3.1.39 <- cuadros_314fgen(
    df = df,
    columnas_sumar = columnas_sumar39,
    renombrado_alias = renombrado_alias39)
  
  cuadro_3.1.39 <- cuadro_3.1.39 %>%
    select(-last_col())
  
# Cuadro 3.1.40 Consultas de morbilidad, prevención, esmatologìa  Número de Urgencias, Número de Atenciones (urgencias), Número de Ingresos /emergencias y  Número de Intervenciones Quirúrgicas en el servicio de hospitalización de los establecimientos de salud, según regiones, provincias y cantones Año 2021.

  columnas_sumar40 = c("tcmps", "mprim", "msubs", "tconpr", "tpc", "tspc", "tcest", "k1105", "k1106", "k1107", "k974", "k975", "k976", "k977c")
  renombrado_alias40 = c(
    "Consultas de morbilidad Total", "Consultas de morbilidad Primeras", "Consultas de morbilidad Subsecuentes", "Consultas de prevención Total", "Consultas de prevención Primeras", "Consultas de prevención Subseceuntes", "Consultas de estomatología Total", "Consultas de estomatología Morbilidad", "Consultas de estomatología Prevención primeras",
    "Consultas de estomatología Prevención subsecuentes", "Número de Urgencias domicilio", "Número de Atenciones (urgencias)", "Número de Ingresos emergencias", "Número de Intervenciones Quirúrgicas en el servicio de hospitalización")
  cuadro_3.1.40 <- cuadros_314fgen(
    df = df,
    columnas_sumar = columnas_sumar40,
    renombrado_alias = renombrado_alias40) 
  
  cuadro_3.1.40 <- cuadro_3.1.40 %>%
    select(-last_col())
  
# Cuadro 3.1.41 Médicos generales y por especialidades, que trabajan en establecimientos de salud, según regiones, provincias y cantón Año 2021.
  
  columnas_sumar41 = c("k6", "k11", "k16", "k16a", "k16b", "k16c", "k16d", "k16e", "k16f", "k191d", "k41", "k21", "k26", "k31", "k36", "k46", "k51", "k56", "k61", "k66", "k71", "k76", "k81", "k86", "k91", "k96", "k101", "k106", "k111", "k116",
                      "k121", "k126", "k131", "k136", "k141", "k146", "k151", "tk156", "k171", "k191a", "k191b", "k191c", "k191e", "k191f", "k191g", "k191h", "k191i", "k191j", "k191k", "k191l", "k191m", "k191n", "k191o", "k191p", "k191q", "k191r", "k191s",
                      "k191t", "k191u", "k191w", "k191x", "k191y", "k191z", "k191aa", "k191cc", "k191dd", "k191ee", "k191")
  renombrado_alias41 = c(
    "Médicos Generales", "Cirujanos Generales", "Cirujanos Plásticos y Reconstructores", "Cirujanos Cardiacos", "Cirujanos Cardiotorácicos", "Cirujanos Cardiovasculares", "Cirujanos de cabeza y cuello",
    "Cirujanos Pediátricos", "Cirujanos Torácicos", "Cirugía Vasculares y Endovasculares", "Ortopédicos y Traumatólogos", "Medicina Interna (Internistas)", "Anestesiólogos", "Cardiólogos", "Neurólogos", "Psiquiatras", "Oftalmólogos", "Otorrinolaringólogos",
    "Hematólogos", "Intensivistas", "Nefrólogos", "Neumólogos", "Gastroenterólogos", "Geriátras y Gerontólogos", "Oncólogos", "Urólogos", "Dermatólogos", "Infectólogos", "Endocrinólogos", "Alergólogos", "Diabetólogos", "Pediatras", "Neonatólogos", "Ginecólogos/Obstetras",
    "De Salud Pública (Salubristas)", "Epidemiólogos", "De Salud Familiar y Comunitaria", "Laboratorio/2", "Radiólogo", "Nutriólogos", "Reumatólogo", "Cardiotorácico", "Neurocirujanos", "Fisiatras", "Médicos Acupunturistas", "Especialistas en Atención Primaria en Salud",
    "Audiólogos / Foniatras", "Biólogos Moleculares", "Genetistas Clínicos", "Genetistas Médicos", "Homeópatas", "Imagenólogos", "Inmunólogos", "Médicos Aeroespaciales", "Médicos Críticos", "Médicos de Emergencia", "Médicos del Deporte", "Médicos Ocupacional", "Médicos Nucleares",
    "Neurofisiólogo Clínico", "Neuropsicólogos", "Parasitólogos", "Proctólogos", "Psiquiatras Infantiles", "Subespecialistas",  "Terapistas Neural", "Especialista en Ultrasonido", "Otros")
  
  cuadro_3.1.41 <- cuadros_314fgen(
    df = df,
    columnas_sumar = columnas_sumar41,
    renombrado_alias = renombrado_alias41) 
  
  cuadro_3.1.41 <- cuadro_3.1.41 %>%
    select(-last_col())

# *********************SINTAXIS 5 GENERACIÓN TABULADOS RAS*************************

# Crear un workbook y agregar una hoja
  
  
  lista_tabulados <- list(
    "serie_1.1.1" = serie_1.1.1,
    "serie_1.1.2" = serie_1.1.2,
    "serie_1.1.3" = serie_1.1.3,
    "serie_1.1.4" = serie_1.1.4,
    "serie_1.1.5" = serie_1.1.5,
    "serie_1.2.1" = serie_1.2.1,
    "serie_1.2.2" = serie_1.2.2,
    "serie_1.2.3" = serie_1.2.3,
    "serie_1.2.4" = serie_1.2.4,
    "serie_1.2.5" = serie_1.2.5,
    "serie_1.2.6" = serie_1.2.6,
    "gráfico_2.1.1" = gráfico_2.1.1,
    "gráfico_2.1.2" = gráfico_2.1.2,
    "gráfico_2.1.3" = gráfico_2.1.3,
    "gráfico_2.1.4_1" = gráfico_2.1.4_1,
    "gráfico_2.1.4_2" = gráfico_2.1.4_2,
    "gráfico_2.1.4_3" = gráfico_2.1.4_3,
    "cuadro_3.1.1" = cuadro_3.1.1,
    "cuadro_3.1.2" = cuadro_3.1.2,
    "cuadro_3.1.3" = cuadro_3.1.3,
    "cuadro_3.1.4" = cuadro_3.1.4,
    "cuadro_3.1.5" = cuadro_3.1.5,
    "cuadro_3.1.6" = cuadro_3.1.6,
    "cuadro_3.1.7" = cuadro_3.1.7,
    "cuadro_3.1.8" = cuadro_3.1.8,
    "cuadro_3.1.9" = cuadro_3.1.9,
    "cuadro_3.1.10" = cuadro_3.1.10,
    "cuadro_3.1.11" = cuadro_3.1.11,
    "cuadro_3.1.12" = cuadro_3.1.12,
    "cuadro_3.1.13" = cuadro_3.1.13,
    "cuadro_3.1.14" = cuadro_3.1.14,
    "cuadro_3.1.15" = cuadro_3.1.15,
    "cuadro_3.1.16" = cuadro_3.1.16,
    "cuadro_3.1.17" = cuadro_3.1.17,
    "cuadro_3.1.18" = cuadro_3.1.18,
    "cuadro_3.1.19" = cuadro_3.1.19,
    "cuadro_3.1.20" = cuadro_3.1.20,
    "cuadro_3.1.21" = cuadro_3.1.21,
    "cuadro_3.1.22a" = cuadro_3.1.22a,
    "cuadro_3.1.22b" = cuadro_3.1.22b,
    "cuadro_3.1.23" = cuadro_3.1.23,
    "cuadro_3.1.24" = cuadro_3.1.24,
    "cuadro_3.1.25" = cuadro_3.1.25,
    "cuadro_3.1.26" = cuadro_3.1.26,
    "cuadro_3.1.27" = cuadro_3.1.27,
    "cuadro_3.1.28" = cuadro_3.1.28,
    "cuadro_3.1.29" = cuadro_3.1.29,
    "cuadro_3.1.30" = cuadro_3.1.30,
    "cuadro_3.1.31" = cuadro_3.1.31,
    "cuadro_3.1.32" = cuadro_3.1.32,
    "cuadro_3.1.33" = cuadro_3.1.33,
    "cuadro_3.1.34" = cuadro_3.1.34,
    "cuadro_3.1.35" = cuadro_3.1.35,
    "cuadro_3.1.36" = cuadro_3.1.36,
    "cuadro_3.1.37" = cuadro_3.1.37,
    "cuadro_3.1.38" = cuadro_3.1.38,
    "cuadro_3.1.39" = cuadro_3.1.39,
    "cuadro_3.1.40" = cuadro_3.1.40,
    "cuadro_3.1.41" = cuadro_3.1.41
      )
  
  # 2. Exportamos la lista completa
  # Cada nombre en la lista se convertirá en una pestaña de Excel
  write_xlsx(lista_tabulados, "Tabulados_2021.xlsx")
